

#critical size using breakpoint
require(segmented)
require(reshape)
require(lattice)
require(epicalc)

data<-XXXXXX
growth<-XXXXXXX


growth<-subset(growth, age<25)

datam<-data[c("age", "ttp")]
datam<-na.omit(datam)
plot(datam)
datam<-as.matrix(datam)

theta=0.5*pi/180
R <- matrix(c(cos(theta), -sin(theta), sin(theta), cos(theta)), nrow=2)

datamr<-datam%*%R

plot(datamr)

datamrd<-as.data.frame(datamr)
names(datamrd)<-c("age","ttp")
glm<-glm(ttp~age, data=datamrd)
davies.test(glm, seg.Z=~age, k=1)
seg<-segmented(glm,seg.Z=~age,psi=list(age=10))
summary(seg)
plot(seg, add=T)
bpage<-seg$psi[,2]
bpagevalue<-bpage
slope<-seg$coefficients[2]
intercept<-seg$coefficients[1]
bpttp<-intercept+slope*bpage


conf<-confint(seg)
low<-conf$age[,2]
high<-conf$age[,3]


bpsunconverted <- matrix(c(bpage, low, high, bpttp, bpttp, bpttp), ncol=2, nrow=3)
Rback <- matrix(c(cos(-theta), -sin(-theta), sin(-theta), cos(-theta)), nrow=2)
CS<-bpsunconverted%*%Rback
CS<-as.data.frame(CS)
TGP<-CS$V2[1]
#TGP
TGP
CA<-CS$V1[1]
#CS as age
CA

#CS as weight
lm<-lm(mass~age, data=growth)
int<-lm$coefficients[1]
slp<-lm$coefficients[2]
CS<-int+slp*CA
#CS as larval weight
CS

#bootstrap


bootCS<-NA
bootTGP<-NA
bootCA<-NA

theta=0.5*pi/180
R <- matrix(c(cos(theta), -sin(theta), sin(theta), cos(theta)), nrow=2)
for (i in 1:1000)
{
  detachAllData()
  bootdataall<-data[sample(nrow(data),nrow(data), replace=T),]
  bootdata<-bootdataall[c("age", "ttp")]
  bootdatam<-na.omit(bootdata)
  bootdatam<-as.matrix(bootdatam)
  bootdatamr<-bootdatam%*%R
  bootdatamrd<-as.data.frame(bootdatamr)
  glm<-glm(V2~V1, data=bootdatamrd)
  seg<-segmented(glm,seg.Z=~V1,psi=list(V1=bpagevalue))
  bpage<-seg$psi[,2]
  slope<-seg$coefficients[2]
  intercept<-seg$coefficients[1]
  bpttp<-intercept+slope*bpage
  bpsunconverted <- matrix(c(bpage ,bpttp), ncol=2, nrow=1)
  Rback <- matrix(c(cos(-theta), -sin(-theta), sin(-theta), cos(-theta)), nrow=2)
  CAandTGP<-bpsunconverted%*%Rback
  CA<-CAandTGP[,1]
  bootCA<-rbind(bootCA,CA)
  TGP<-CAandTGP[,2]
  bootTGP<-rbind(bootTGP,TGP)
  bootgrowth<-growth[sample(nrow(growth),nrow(growth), replace=T),]
  lm<-lm(mass~age, data=bootgrowth)
  int<-lm$coefficients[1]
  slp<-lm$coefficients[2]
  CS<-int+slp*CA
  #CS as larval weight
  bootCS<-rbind(bootCS,CS)
}
  bootCA<-na.omit(bootCA)
  bootCS<-na.omit(bootCS)
  bootTGP<-na.omit(bootTGP)
  
  mean(bootCA)
  quantile(bootCA, probs=c(.025,.975))

  mean(bootCS)
  quantile(bootCS, probs=c(.025,.975))
  
  mean(bootTGP)
  quantile(bootTGP, probs=c(.025,.975))
  